/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.exception;

import cn.ipokerface.weixin.request.WeixinErrorHolder;
import cn.ipokerface.weixin.utils.StringUtil;

public class WeixinException
extends Exception {
    private static final long serialVersionUID = 7148145661883468514L;
    private String code;
    private String desc;

    public WeixinException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public WeixinException(String desc) {
        this.code = "-1";
        this.desc = desc;
    }

    public WeixinException(Throwable e) {
        super(e);
    }

    public WeixinException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getErrorCode() {
        return this.code;
    }

    public String getErrorDesc() {
        return this.desc;
    }

    public String getErrorText() {
        return WeixinErrorHolder.getText(this.code);
    }

    public String getMessage() {
        if (StringUtil.isNotBlank(this.code)) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.code).append(" >> ").append(this.desc);
            String text = this.getErrorText();
            if (StringUtil.isNotBlank(text)) {
                buf.append(" >> ").append(text);
            }
            return buf.toString();
        }
        return super.getMessage();
    }
}

