/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.cache;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.cache.Cacheable;
import cn.ipokerface.weixin.utils.SerializationUtils;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCacheStorager<T extends Cacheable>
implements AbstractCacheStorager<T> {
    private static final String keys = "weixin_cache_keys";
    private Pool<Jedis> jedisPool;
    private static final int TIMEOUT = 5000;
    private static final int MAX_TOTAL = 50;
    private static final int MAX_IDLE = 5;
    private static final int MAX_WAIT_MILLIS = 5000;
    private static final boolean TEST_ON_BORROW = false;
    private static final boolean TEST_ON_RETURN = true;
    private static final JedisPoolConfig POOLCONFIG = new JedisPoolConfig();

    public RedisCacheStorager(String host, int port, int timeout) {
        this(host, port, timeout, null, POOLCONFIG);
    }

    public RedisCacheStorager(String host, int port, int timeout, String password) {
        this(host, port, timeout, password, POOLCONFIG);
    }

    public RedisCacheStorager(String host, int port, int timeout, String password, JedisPoolConfig poolConfig) {
        this((Pool<Jedis>)new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password));
    }

    public RedisCacheStorager(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T lookup(String key) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            byte[] value = jedis.get(key.getBytes(Constant.UTF_8));
            Cacheable cacheable = value != null ? (Cacheable)SerializationUtils.deserialize(value) : null;
            return (T)cacheable;
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caching(String key, T cache) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            byte[] cacheKey = key.getBytes(Constant.UTF_8);
            byte[] value = SerializationUtils.serialize(cache);
            if (cache.expiredTime() > 0L) {
                jedis.setex(cacheKey, (int)(cache.expiredTime() - 60000L) / 1000, value);
            } else {
                jedis.set(cacheKey, value);
            }
            jedis.sadd(keys, new String[]{key});
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T delete(String key) {
        T cache = this.lookup(key);
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            jedis.del(key);
            jedis.srem(keys, new String[]{key});
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return cache;
    }

    @Override
    public void clear() {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            Set cacheKeys = jedis.smembers(keys);
            if (!cacheKeys.isEmpty()) {
                cacheKeys.add(keys);
                jedis.del(cacheKeys.toArray(new String[cacheKeys.size()]));
            }
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    static {
        POOLCONFIG.setMaxTotal(50);
        POOLCONFIG.setMaxIdle(5);
        POOLCONFIG.setMaxWaitMillis(5000L);
        POOLCONFIG.setTestOnBorrow(false);
        POOLCONFIG.setTestOnReturn(true);
    }
}

