/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.cache;

import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.cache.Cacheable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCacheStorager<T extends Cacheable>
implements AbstractCacheStorager<T> {
    private final Map<String, T> content = new ConcurrentHashMap<String, T>();

    @Override
    public T lookup(String key) {
        Cacheable cache = (Cacheable)this.content.get(key);
        if (cache != null && cache.createTime() + cache.expiredTime() - 60000L > System.currentTimeMillis()) {
            return (T)cache;
        }
        return null;
    }

    @Override
    public void caching(String key, T cache) {
        this.content.put(key, cache);
    }

    @Override
    public T delete(String key) {
        return (T)((Cacheable)this.content.remove(key));
    }

    @Override
    public void clear() {
        this.content.clear();
    }
}

