/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.cache;

import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.cache.CacheCreator;
import cn.ipokerface.weixin.cache.Cacheable;
import cn.ipokerface.weixin.exception.WeixinException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager<T extends Cacheable> {
    protected final CacheCreator<T> cacheCreator;
    protected final AbstractCacheStorager<T> cacheStorager;
    private final ReentrantLock lock = new ReentrantLock();

    public CacheManager(CacheCreator<T> cacheCreator, AbstractCacheStorager<T> cacheStorager) {
        this.cacheCreator = cacheCreator;
        this.cacheStorager = cacheStorager;
    }

    public T getCache() throws WeixinException {
        T cache;
        block6: {
            String cacheKey = this.cacheCreator.key();
            cache = this.cacheStorager.lookup(cacheKey);
            try {
                if (cache != null || !this.lock.tryLock(3L, TimeUnit.SECONDS)) break block6;
                try {
                    cache = this.cacheStorager.lookup(cacheKey);
                    if (cache == null) {
                        cache = this.cacheCreator.create();
                        this.cacheStorager.caching(cacheKey, cache);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                throw new WeixinException("get cache error on lock", e);
            }
        }
        return cache;
    }

    public T refreshCache() throws WeixinException {
        String cacheKey = this.cacheCreator.key();
        T cache = this.cacheCreator.create();
        this.cacheStorager.caching(cacheKey, cache);
        return cache;
    }

    public T evictCache() {
        String cacheKey = this.cacheCreator.key();
        return this.cacheStorager.delete(cacheKey);
    }

    public void clearCache() {
        this.cacheStorager.clear();
    }
}

