package cn.ipokerface.weixin.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class RegexUtil {


    /**
     * Content-disposition 中的 filename提取正则
     */
    private static final Pattern FILENAME_RGX = Pattern
            .compile("(?<=filename=\").*?(?=\")");

    /**
     * 从 Content-disposition提取文件名
     *
     * @param contentDisposition
     * @return
     */
    public static String regexFileNameFromContentDispositionHeader(
            String contentDisposition) {
        if (StringUtil.isBlank(contentDisposition)) {
            return null;
        }
        Matcher filenameMatcher = FILENAME_RGX.matcher(contentDisposition);
        return filenameMatcher.find() ? filenameMatcher.group() : null;
    }
}
