package cn.ipokerface.weixin.utils;

import cn.ipokerface.weixin.Constant;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class DigestUtils {

    private static MessageDigest getDigest(final String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        } catch (final NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /**
     * SHA1签名
     *
     * @param content
     *            待签名字符串
     * @return 签名后的字符串
     */
    public static String SHA1(String content) {
        byte[] data = StringUtil.getBytesUtf8(content);
        return HexUtils.encodeHexString(getDigest(Constant.SHA1).digest(data));
    }

    /**
     * SHA签名
     *
     * @param content
     *            待签名字符串
     * @return 签名后的字符串
     */
    public static String SHA(String content) {
        byte[] data = StringUtil.getBytesUtf8(content);
        return HexUtils.encodeHexString(getDigest(Constant.SHA).digest(data));
    }

    /**
     * MD5签名
     *
     * @param content
     *            待签名字符串
     * @return 签名后的字符串
     */
    public static String MD5(String content) {
        byte[] data = StringUtil.getBytesUtf8(content);
        return HexUtils.encodeHexString(getDigest(Constant.MD5).digest(data));
    }
}
