package cn.ipokerface.weixin.token;

import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.cache.CacheManager;
import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class TokenManager extends CacheManager<Token> {


    /**
     *
     * @param tokenCreator
     *            负责微信各种token的创建
     * @param cacheStorager
     *            负责token的存储
     */
    public TokenManager(TokenCreator tokenCreator, AbstractCacheStorager<Token> cacheStorager) {
        super(tokenCreator, cacheStorager);
    }

    /**
     * 获取token字符串
     *
     * @return token字符串
     * @throws WeixinException
     */
    public String getAccessToken() throws WeixinException {
        return super.getCache().getAccessToken();
    }

    /**
     * 返回唯一标识ID
     *
     * @return
     */
    public String getWeixinId() {
        return ((TokenCreator) cacheCreator).uniqueid();
    }
}
