package cn.ipokerface.weixin.token;

import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.model.Token;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class TicketPermanentManager extends TicketManager {

    private final String authAppId;

    public TicketPermanentManager(String authAppId, String thirdId,
                            String thirdSecret, AbstractCacheStorager<Token> cacheStorager) {
        super(thirdId, thirdSecret, cacheStorager);
        this.authAppId = authAppId;
    }

    /**
     * 获取永久授权码的key
     *
     * @return
     */
    @Override
    public String getCacheKey() {
        return String.format("%sthird_party_percode_ticket_%s_%s",
                TokenCreator.CACHEKEY_PREFIX, getThirdId(), authAppId);
    }

    public String getAuthAppId() {
        return authAppId;
    }
}
