package cn.ipokerface.weixin.sign;

import cn.ipokerface.weixin.utils.DigestUtils;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinPaymentSignature extends AbstractWeixinSignature {
    /**
     * 支付密钥
     */
    private final String paySignKey;

    public WeixinPaymentSignature(String paySignKey) {
        this.paySignKey = paySignKey;
    }

    @Override
    public SignType getSignType() {
        return SignType.MD5;
    }

    @Override
    public String sign(Object obj) {
        StringBuilder sb = join(obj).append("&key=").append(paySignKey);
        return DigestUtils.MD5(sb.toString()).toUpperCase();
    }
}
