package cn.ipokerface.weixin.request.http.simple;

import cn.ipokerface.weixin.request.http.AbstractHttpResponse;
import cn.ipokerface.weixin.request.http.HttpHeaders;
import cn.ipokerface.weixin.request.http.HttpStatus;
import cn.ipokerface.weixin.request.http.HttpVersion;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class SimpleHttpResponse extends AbstractHttpResponse {

    private final HttpURLConnection connection;

    private HttpHeaders headers;
    private HttpVersion protocol;
    private HttpStatus status;

    public SimpleHttpResponse(HttpURLConnection connection, byte[] content) {
        super(content);
        this.connection = connection;
    }

    public HttpVersion getProtocol() {
        String version = connection.getHeaderField(null);
        if (version == null) {
            return null;
        }
        if (protocol == null) {
            if (version.contains(HttpVersion.HTTP_1_0_STRING)) {
                protocol = HttpVersion.HTTP_1_0;
            } else if (version.contains(HttpVersion.HTTP_1_1_STRING)) {
                protocol = HttpVersion.HTTP_1_1;
            } else {
                String connect = connection.getHeaderField("Connection");
                protocol = new HttpVersion(version,
                        KEEP_ALIVE.equalsIgnoreCase(connect));
            }
        }
        return protocol;
    }

    public HttpHeaders getHeaders() {
        if (headers == null) {
            headers = new HttpHeaders();
            Map<String, List<String>> headerFields = connection
                    .getHeaderFields();
            for (Map.Entry<String, List<String>> headerEntry : headerFields
                    .entrySet()) {
                headers.put(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        return headers;
    }


    public HttpStatus getStatus() {
        if (status == null) {
            try {
                status = new HttpStatus(connection.getResponseCode(),
                        connection.getResponseMessage());
            } catch (IOException e) {
                throw new RuntimeException("I/O Error on getStatus", e);
            }
        }
        return status;
    }

    public void close() {
        connection.disconnect();
    }
}