package cn.ipokerface.weixin.request.http.message;

import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.MimeType;

import java.io.IOException;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface MessageConverter {


    /**
     * 获取可以转换的媒体类型
     *
     * @return 媒体列表
     */
    public List<MimeType> supportedMimeTypes();

    /**
     * 是否可以转换
     *
     * @param clazz
     *            转换类型
     * @param response
     *            响应对象
     * @return 是否标识
     */
    public boolean canConvert(Class<?> clazz, HttpResponse response);

    /**
     * 转换消息
     *
     * @param clazz
     *            转换类型
     * @param response
     *            响应对象
     * @throws IOException
     * @return 消息对象
     */
    public <T> T convert(Class<? extends T> clazz, HttpResponse response)
            throws IOException;
}
