package cn.ipokerface.weixin.request.http.message;

import cn.ipokerface.weixin.request.http.HttpHeaders;
import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.MimeType;
import cn.ipokerface.weixin.utils.FileUtils;
import cn.ipokerface.weixin.utils.IOUtils;
import cn.ipokerface.weixin.utils.RegexUtil;
import com.alibaba.fastjson.JSON;

import java.io.IOException;
import java.io.InputStream;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class JsonMessageConverter extends AbstractMessageConverter {
    public static final JsonMessageConverter GLOBAL = new JsonMessageConverter();

    private static final String JSO = "json";
    private static final int BRACE = 1 << '{';
    private static final int BRACKET = 1 << '[';
    private static final int MASK = BRACE | BRACKET;

    public JsonMessageConverter() {
        super(MimeType.APPLICATION_JSON, MimeType.TEXT_JSON, new MimeType(
                "application", "*+json"));
    }

    @Override
    public boolean canConvert(Class<?> clazz, HttpResponse response) {
        if (!super.canConvert(clazz, response)) {
            String disposition = response.getHeaders().getFirst(
                    HttpHeaders.CONTENT_DISPOSITION);
            String fileName = RegexUtil
                    .regexFileNameFromContentDispositionHeader(disposition);
            return (fileName != null && FileUtils.getFileExtension(fileName)
                    .equalsIgnoreCase(JSO));
        }
        return true;
    }

    @Override
    protected boolean supports(Class<?> clazz, byte[] content) {
        return (MASK & (1 << content[0])) != 0;
    }

    @Override
    protected <T> T convertInternal(Class<? extends T> clazz, InputStream body)
            throws IOException {
        byte[] bytes = IOUtils.toByteArray(body);
        return JSON.parseObject(bytes, 0, bytes.length, charset.newDecoder(),
                clazz);
    }
}