package cn.ipokerface.weixin.request.http.apache;

import cn.ipokerface.weixin.request.http.ContentType;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class InputStreamBody extends AbstractContentBody {

    private final InputStream in;
    private final String filename;

    /**
     * @since 4.1
     *
     */
    public InputStreamBody(final InputStream in, final String mimeType,
                           final String filename) {
        this(in, ContentType.create(mimeType), filename);
    }

    public InputStreamBody(final InputStream in, final String filename) {
        this(in, ContentType.DEFAULT_BINARY, filename);
    }

    /**
     * @since 4.3
     */
    public InputStreamBody(final InputStream in, final ContentType contentType,
                           final String filename) {
        super(contentType);
        this.in = in;
        this.filename = filename;
    }

    /**
     * @since 4.3
     */
    public InputStreamBody(final InputStream in, final ContentType contentType) {
        this(in, contentType, null);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public void writeTo(final OutputStream out) throws IOException {
        try {
            final byte[] tmp = new byte[4096];
            int l;
            while ((l = this.in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        } finally {
            this.in.close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return Mime.ENC_BINARY;
    }

    @Override
    public long getContentLength() {
        try {
            return in.available();
        } catch (IOException e) {
            return -1;
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

}
