package cn.ipokerface.weixin.request.http.apache;

import cn.ipokerface.weixin.request.http.ContentType;

import java.io.*;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class FileBody extends AbstractContentBody {

    private final File file;
    private final String filename;

    /**
     * @since 4.1
     *
     */
    public FileBody(final File file, final String filename,
                    final String mimeType, final String charset) {
        this(file, ContentType.create(mimeType, charset), filename);
    }

    /**
     * @since 4.1
     *
     */
    public FileBody(final File file, final String mimeType, final String charset) {
        this(file, null, mimeType, charset);
    }

    /**
     */
    public FileBody(final File file, final String mimeType) {
        this(file, ContentType.create(mimeType), null);
    }

    public FileBody(final File file) {
        this(file, ContentType.DEFAULT_BINARY, file != null ? file.getName()
                : null);
    }

    /**
     * @since 4.3
     */
    public FileBody(final File file, final ContentType contentType,
                    final String filename) {
        super(contentType);
        this.file = file;
        this.filename = filename == null ? file.getName() : filename;
    }

    /**
     * @since 4.3
     */
    public FileBody(final File file, final ContentType contentType) {
        this(file, contentType, file != null ? file.getName() : null);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public void writeTo(final OutputStream out) throws IOException {
        final InputStream in = new FileInputStream(this.file);
        try {
            final byte[] tmp = new byte[4096];
            int l;
            while ((l = in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        } finally {
            in.close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return Mime.ENC_BINARY;
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getFilename() {
        return filename;
    }

    public File getFile() {
        return this.file;
    }

}