package cn.ipokerface.weixin.request.http;

import cn.ipokerface.weixin.request.http.entity.HttpEntity;

import java.net.URI;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class HttpRequest implements  HttpMessage {
    /**
     * 请求方式
     *
     * @return
     */
    private final HttpMethod method;

    /**
     * 请求路径
     *
     * @return
     */
    private final URI uri;
    /**
     * 内容参数
     */
    private HttpEntity entity;
    /**
     * 请求表头
     */
    private HttpHeaders headers;

    public HttpRequest(HttpMethod method, URI uri) {
        this.method = method;
        this.uri = uri;
    }

    public HttpRequest(HttpMethod method, String url) {
        this(method, URI.create(url));
    }

    public HttpMethod getMethod() {
        return method;
    }

    public URI getURI() {
        return uri;
    }

    public HttpEntity getEntity() {
        return entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public HttpHeaders getHeaders() {
        return headers;
    }
}
