package cn.ipokerface.weixin.request.http;

import cn.ipokerface.weixin.request.http.entity.HttpEntity;

import java.util.Set;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface HttpClient {

    // get
    HttpResponse get(String url) throws HttpClientException;

    HttpResponse get(String url, URLParameter... parameters)
            throws HttpClientException;

    // head
    HttpHeaders head(String url) throws HttpClientException;

    HttpHeaders head(String url, URLParameter... parameters)
            throws HttpClientException;

    // post
    HttpResponse post(String url) throws HttpClientException;

    HttpResponse post(String url, URLParameter... parameters)
            throws HttpClientException;

    HttpResponse post(String url, HttpEntity httpEntity)
            throws HttpClientException;

    // put
    void put(String url) throws HttpClientException;

    void put(String url, URLParameter... parameters) throws HttpClientException;

    // delete
    void delete(String url) throws HttpClientException;

    void delete(String url, URLParameter... parameters)
            throws HttpClientException;

    // OPTIONS
    Set<HttpMethod> options(String url) throws HttpClientException;

    Set<HttpMethod> options(String url, URLParameter... parameters)
            throws HttpClientException;

    /**
     * 处理请求
     *
     * @param request
     *            请求对象
     * @return 响应对象
     * @throws HttpClientException
     */
    HttpResponse execute(HttpRequest request) throws HttpClientException;
}
