package cn.ipokerface.weixin.proxy.redpack;

import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.utils.DateUtils;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class RedPacketSendResult extends MerchantResult {

    private static final long serialVersionUID = 5611847899634131711L;
    /**
     * 商户订单号（每个订单号必须唯一） 组成： mch_id+yyyymmdd+10位一天内不能重复的数字。
     */
    @XmlElement(name = "mch_billno")
    @JSONField(name = "mch_billno")
    private String outTradeNo;
    /**
     * 接收红包的用户的openid
     */
    @XmlElement(name = "re_openid")
    @JSONField(name = "re_openid")
    private String openId;
    /**
     * 付款金额 单位为分
     */
    @XmlElement(name = "total_amount")
    @JSONField(name = "total_amount")
    private int totalAmount;
    /**
     * 发放成功时间
     */
    @XmlElement(name = "send_time")
    @JSONField(name = "send_time")
    private String sendTime;
    /**
     * 微信单号
     */
    @XmlElement(name = "send_listid")
    @JSONField(name = "send_listid")
    private String sendListid;

    protected RedPacketSendResult() {
        // jaxb required
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public String getOpenId() {
        return openId;
    }

    public int getTotalAmount() {
        return totalAmount;
    }

    /**
     * <font color="red">调用接口获取单位为分,get方法转换为元方便使用</font>
     *
     * @return 元单位
     */
    @JSONField(serialize = false)
    public double getFormatTotalAmount() {
        return totalAmount / 100d;
    }

    public String getSendTime() {
        return sendTime;
    }

    @JSONField(serialize = false)
    public Date getFormatSendTime() {
        return DateUtils.parse2yyyyMMddHHmmss(sendTime);
    }

    public String getSendListid() {
        return sendListid;
    }

    @Override
    public String toString() {
        return "RedpacketSendResult [outTradeNo=" + outTradeNo + ", openId="
                + openId + ", totalAmount=" + totalAmount + ", "
                + super.toString() + "]";
    }
}