package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.payment.TradeType;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WapPaymentRequest extends AbstractPaymentRequest {
    /**
     * 微信支付URL
     */
    private final String payUrl;

    public WapPaymentRequest(String prePayId, String payUrl,
                         WeixinPayAccount payAccount) {
        super(prePayId, payAccount);
        this.payUrl = payUrl;

    }

    @Override
    public TradeType getPaymentType() {
        return TradeType.MWEB;
    }

    /**
     * <font color="red">只做查看之用,请不要尝试作为支付请求</font>
     */
    @Override
    public PaymentRequest toRequestObject() {
        PaymentRequest payRequest = new PaymentRequest(getPaymentAccount().getId(),
                getPaymentType().name());
        payRequest.setPrepayId(getPrePayId());
        return payRequest;
    }

    @Override
    public String toRequestString() {
        // PayRequest payRequest = toRequestObject();
        // String original = MapUtil.toJoinString(payRequest, true, true);
        // String sign = DigestUtil.MD5(
        // String.format("%s&key=%s", original, getPaymentAccount()
        // .getPaySignKey())).toUpperCase();
        // return String.format("weixin://wap/pay?%s",
        // URLEncodingUtil.encoding(
        // String.format("%s&sign=%s", original, sign),
        // Consts.UTF_8, true));
        return this.payUrl;
    }
}