package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.payment.TradeType;
import cn.ipokerface.weixin.proxy.merchant.MerchantResult;

import javax.xml.bind.annotation.*;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class PrePayment extends MerchantResult {

    private static final long serialVersionUID = -8430005768959715444L;

    /**
     * 调用接口提交的交易类型，取值如下：JSAPI，NATIVE，APP，
     *
     * @see TradeType
     */
    @XmlElement(name = "trade_type")
    private TradeType tradeType;
    /**
     * 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    @XmlElement(name = "prepay_id")
    private String prepayId;
    /**
     * 对于trade_type 为 NATIVE 或者 MWEB 是有 返回 NATVIE支付：可直接生成二维码展示出来进行扫码支付可能为空
     * MWEB支付：可直接作为跳转支付的URL
     */
    @XmlElements({ @XmlElement(name = "code_url"),
            @XmlElement(name = "mweb_url") })
    private String payUrl;

    protected PrePayment() {
        // jaxb required
    }

    public PrePayment(String returnCode, String returnMsg) {
        super(returnCode, returnMsg);
    }

    public TradeType getTradeType() {
        return tradeType;
    }

    public void setTradeType(TradeType tradeType) {
        this.tradeType = tradeType;
    }

    public String getPrepayId() {
        return prepayId;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }

    public String getPayUrl() {
        return payUrl;
    }

    public void setPayUrl(String payUrl) {
        this.payUrl = payUrl;
    }

    @Override
    public String toString() {
        return "PrePay [tradeType=" + tradeType + ", prepayId=" + prepayId
                + ", payUrl=" + payUrl + ", " + super.toString() + "]";
    }
}
