package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class OpenidResult extends MerchantResult {

    private static final long serialVersionUID = 902743989722741814L;

    /**
     * 用户在商户appid下的唯一标识
     */
    @XmlElement(name = "openid")
    @JSONField(name = "openid")
    private String openId;

    /**
     * 用户在商户appid下的唯一标识
     */
    @XmlElement(name = "sub_openid")
    @JSONField(name = "sub_openid")
    private String subOpenId;

    public String getOpenId() {
        return openId;
    }

    public String getSubOpenId() {
        return subOpenId;
    }

    @Override
    public String toString() {
        return "OpenIdResult [openId=" + openId + ", subOpenId=" + subOpenId
                + ", " + super.toString() + "]";
    }
}
