package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.sign.WeixinPaymentSignature;
import cn.ipokerface.weixin.utils.RandomUtil;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class NativePaymentResponse extends MerchantResult {

    private static final long serialVersionUID = 6119895998783333012L;

    @XmlElement(name = "prepay_id")
    @JSONField(name = "prepay_id")
    private String prepayId;

    protected NativePaymentResponse() {
        // jaxb required
    }

    /**
     * 作为return_code 为 FAIL 的时候返回
     *
     * @param returnMsg
     *            失败消息
     * @param resultMsg
     *            结果消息
     */
    public NativePaymentResponse(String returnMsg, String resultMsg) {
        super(Constant.FAIL, returnMsg);
        super.setErrCodeDes(resultMsg);
        super.setResultCode(Constant.FAIL);
    }

    /**
     * 作为return_code 为 SUCCESS 的时候返回
     *
     * @param weixinAccount
     *            商户信息
     * @param prepayId
     *            调用统一下单接口生成的预支付ID
     */
    public NativePaymentResponse(WeixinPayAccount weixinAccount, String prepayId) {
        super(Constant.SUCCESS, "OK");
        this.setResultCode(Constant.SUCCESS);
        this.setMchId(weixinAccount.getMchId());
        this.setAppId(weixinAccount.getId());
        this.setNonceStr(RandomUtil.generateString(16));
        this.prepayId = prepayId;
        this.setSign(new WeixinPaymentSignature(weixinAccount.getPaySignKey())
                .sign(this));
    }

    public String getPrepayId() {
        return prepayId;
    }

    @Override
    public String toString() {
        return "NativePayResponse [prepayId=" + prepayId + ", "
                + super.toString() + "]";
    }
}