package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.payment.TradeType;
import cn.ipokerface.weixin.proxy.merchant.Order;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlTransient;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class MicroPaymentRequest extends Order implements MerchantPaymentRequest {
    private static final long serialVersionUID = 6147576305404111278L;

    @XmlTransient
    @JSONField(serialize = false)
    private WeixinPayAccount paymentAccount;

    protected MicroPaymentRequest() {
        // jaxb required
    }

    @Override
    @JSONField(serialize = false)
    public TradeType getPaymentType() {
        return TradeType.MICROPAY;
    }

    /**
     * <font color="red">返回null,请不要尝试作为支付请求</font>
     */
    @Override
    @JSONField(serialize = false)
    public String toRequestString() {
        return null;
    }

    /**
     * <font color="red">返回null,请不要尝试作为支付请求</font>
     */
    @JSONField(serialize = false)
    @Override
    public PaymentRequest toRequestObject() {
        return null;
    }

    /**
     * <font color="red">返回null,请不要尝试作为支付请求</font>
     */
    @JSONField(serialize = false)
    @Override
    public String getPrePayId() {
        return null;
    }

    public void setPaymentAccount(WeixinPayAccount paymentAccount) {
        this.paymentAccount = paymentAccount;
    }

    @Override
    public WeixinPayAccount getPaymentAccount() {
        return this.paymentAccount;
    }
}
