package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.payment.TradeType;
import cn.ipokerface.weixin.sign.SignType;
import cn.ipokerface.weixin.utils.DigestUtils;
import cn.ipokerface.weixin.utils.MapUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class AppPaymentRequest extends AbstractPaymentRequest {
    public AppPaymentRequest(String prePayId, WeixinPayAccount payAccount) {
        super(prePayId, payAccount);
    }

    @Override
    public TradeType getPaymentType() {
        return TradeType.APP;
    }

    /**
     * <font color="red">只做查看之用,请不要尝试作为支付请求</font>
     */
    @Override
    public PaymentRequest toRequestObject() {
        PaymentRequest payRequest = new PaymentRequest(getPaymentAccount().getId(), "Sign=WXPay");
        payRequest.setPartnerId(getPaymentAccount().getMchId());
        payRequest.setPrepayId(getPrePayId());
        Map<String, String> map = new HashMap<String, String>();
        map.put("appid", payRequest.getAppId());
        // 因为partnerid和prepayid在PayRequest类中是不进行序列化的
        map.put("partnerid", payRequest.getPartnerId());
        map.put("prepayid", payRequest.getPrepayId());
        map.put("package", payRequest.getPackageInfo());
        map.put("timestamp", payRequest.getTimeStamp());
        map.put("noncestr", payRequest.getNonceStr());
        String sign = DigestUtils.MD5(
                String.format("%s&key=%s", MapUtils.toJoinString(map, false, true), getPaymentAccount().getPaySignKey()))
                .toUpperCase();
        payRequest.setPaySign(sign);
        payRequest.setSignType(SignType.MD5);
        return payRequest;
    }

    @Override
    public String toRequestString() {
        PaymentRequest payRequest = toRequestObject();
        StringBuilder content = new StringBuilder();
        content.append("<xml>");
        content.append(String.format("<appid><![CDATA[%s]]></appid>", payRequest.getAppId()));
        content.append(String.format("<partnerid><![CDATA[%s]]></partnerid>", payRequest.getPartnerId()));
        content.append(String.format("<prepayid><![CDATA[%s]]></prepayid>", payRequest.getPrepayId()));
        content.append(String.format("<package><![CDATA[%s]]></package>", payRequest.getPackageInfo()));
        content.append(String.format("<noncestr><![CDATA[%s]]></noncestr>", payRequest.getNonceStr()));
        content.append(String.format("<timestamp><![CDATA[%s]]></timestamp>", payRequest.getTimeStamp()));
        content.append(String.format("<sign><![CDATA[%s]]></sign>", payRequest.getPaySign()));
        content.append("</xml>");
        return content.toString();
    }
}