package cn.ipokerface.weixin.proxy.order;

import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.xml.ListSuffixResult;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlElement;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class CustomOrderRecord extends MerchantResult {

    private static final long serialVersionUID = -1675090110657154049L;
    /**
     * 微信支付订单号
     */
    @XmlElement(name = "transaction_id")
    @JSONField(name = "transaction_id")
    private String transactionId;
    /**
     * 笔数
     */
    @XmlElement(name = "count")
    @JSONField(name = "count")
    private int orderCount;

    /**
     * 报关详情
     *
     * @see CustomOrderResult
     */
    @ListSuffixResult
    private List<CustomOrderResult> customsOrderList;

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public int getOrderCount() {
        return orderCount;
    }

    public void setOrderCount(int orderCount) {
        this.orderCount = orderCount;
    }

    public List<CustomOrderResult> getCustomsOrderList() {
        return customsOrderList;
    }

    public void setCustomsOrderList(List<CustomOrderResult> customsOrderList) {
        this.customsOrderList = customsOrderList;
    }

    @Override
    public String toString() {
        return "CustomsOrderRecord [transactionId=" + transactionId
                + ", orderCount=" + orderCount + ", customsOrderList="
                + customsOrderList + "]";
    }
}