package cn.ipokerface.weixin.model.media;

import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlElement;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class MpVideoMessageTuple implements MultiMessageTuple {

    private static final long serialVersionUID = 2167437425244069128L;

    @Override
    public String getMessageType() {
        return "mpvideo";
    }

    /**
     * 上传视频后微信返回的媒体ID
     */
    @JSONField(name = "media_id")
    @XmlElement(name = "MediaId")
    private String mediaId;

    @JSONCreator
    public MpVideoMessageTuple(@JSONField(name = "mediaId") String mediaId) {
        this.mediaId = mediaId;
    }

    public String getMediaId() {
        return mediaId;
    }

    @Override
    public String toString() {
        return "MpVideo [mediaId=" + mediaId + "]";
    }
}
