package cn.ipokerface.weixin.model.media;

import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class MpNewsMessageTuple implements MultiMessageTuple, NotifyMessageTuple{

    private static final long serialVersionUID = 8853054484809101524L;

    /**
     * 允许最多的图文列表数
     */
    private static final int MAX_ARTICLE_COUNT = 8;

    @Override
    public String getMessageType() {
        return "mpnews";
    }

    /**
     * 上传图文列表后微信返回的媒体ID
     */
    @JSONField(name = "media_id")
    @XmlElement(name = "MediaId")
    private String mediaId;
    /**
     * 图文列表
     */
    @XmlTransient
    private LinkedList<MpArticle> articles;

    /**
     * 群发消息、客服消息 预先上传List#MpArticle得到mediaId
     *
     * @param mediaId
     *            群发素材的媒体ID
     */
    public MpNewsMessageTuple(String mediaId) {
        this.mediaId = mediaId;
        this.articles = new LinkedList<MpArticle>();
    }

    /**
     * 群发消息 自动上传List#MpArticle得到mediaId
     *
     * @param articles
     *            文章列表
     */
    public MpNewsMessageTuple(MpArticle... articles) {
        this.articles = new LinkedList<MpArticle>(Arrays.asList(articles));
    }

    /**
     * @param thumbMediaId
     *            缩略图
     * @param title
     *            标题
     * @param content
     *            内容
     */
    public MpNewsMessageTuple addArticle(String thumbMediaId, String title, String content) {
        return addArticle(new MpArticle(thumbMediaId, title, content));
    }

    public MpNewsMessageTuple addArticle(MpArticle... articles) {
        for (MpArticle article : articles) {
            this.articles.add(article);
        }
        return this;
    }

    public MpNewsMessageTuple addFirstArticle(MpArticle article) {
        articles.addFirst(article);
        return this;
    }

    public MpNewsMessageTuple addLastArticle(MpArticle article) {
        articles.addLast(article);
        return this;
    }

    public MpNewsMessageTuple removeFirstArticle() {
        articles.removeFirst();
        return this;
    }

    public MpNewsMessageTuple removeLastArticle() {
        articles.removeLast();
        return this;
    }

    @JSONField(serialize = false)
    @XmlTransient
    public boolean isMaxCount() {
        return articles.size() == MAX_ARTICLE_COUNT;
    }

    public List<MpArticle> getArticles() {
        if (articles.size() > MAX_ARTICLE_COUNT) {
            return articles.subList(0, MAX_ARTICLE_COUNT);
        } else {
            return articles;
        }
    }

    @JSONField(serialize = false)
    @XmlTransient
    public List<MpArticle> getFullArticles() {
        return articles;
    }

    public String getMediaId() {
        return mediaId;
    }

    @Override
    public String toString() {
        return "MpNews [articles=" + articles + ", mediaId=" + mediaId + "]";
    }
}