package cn.ipokerface.weixin.model.media;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class MediaUploadResult implements Serializable {

    private static final long serialVersionUID = -620630472640999536L;
    private String mediaId;
    private MediaType mediaType;
    private Date createdAt;
    /**
     * 新增的图片素材的图片URL
     */
    private String url;

    public MediaUploadResult(String mediaId, MediaType mediaType,
                             Date createdAt, String url) {
        this.mediaId = mediaId;
        this.mediaType = mediaType;
        this.createdAt = createdAt;
        this.url = url;
    }

    public String getMediaId() {
        return mediaId;
    }

    public MediaType getMediaType() {
        return mediaType;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public String getUrl() {
        return url;
    }

    @Override
    public String toString() {
        return "MediaUploadResult [mediaId=" + mediaId + ", mediaType="
                + mediaType + ", createdAt=" + createdAt + ", url=" + url + "]";
    }
}
