package cn.ipokerface.weixin.model.media;

import cn.ipokerface.weixin.request.http.ContentType;

import java.io.Serializable;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class MediaDownloadResult implements Serializable {

    private static final long serialVersionUID = -7090523911701729058L;
    /**
     * 内容
     */
    private byte[] content;
    /**
     * 类型
     */
    private ContentType contentType;
    /**
     * 文件名
     */
    private String fileName;

    public byte[] getContent() {
        return content;
    }

    public ContentType getContentType() {
        return contentType;
    }

    public String getFileName() {
        return fileName;
    }

    public MediaDownloadResult(byte[] content, ContentType contentType,
                               String fileName) {
        this.content = content;
        this.contentType = contentType;
        this.fileName = fileName;
    }

    @Override
    public String toString() {
        return "MediaDownloadResult [content=..., contentType=" + contentType
                + ", fileName=" + fileName + "]";
    }
}
