package cn.ipokerface.weixin.model.media;

import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlElement;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class CardMessageTuple implements MultiMessageTuple, NotifyMessageTuple {
    private static final long serialVersionUID = 6119453633595102147L;

    @Override
    public String getMessageType() {
        return "wxcard";
    }

    /**
     * 上传后的微信返回的媒体ID
     */
    @JSONField(name = "card_id")
    @XmlElement(name = "CardId")
    private String cardId;

    @JSONCreator
    public CardMessageTuple(@JSONField(name = "cardId") String cardId) {
        this.cardId = cardId;
    }

    public String getCardId() {
        return cardId;
    }

    @Override
    public String toString() {
        return "Card [cardId=" + cardId + "]";
    }
}
