package cn.ipokerface.weixin.model.card;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class CardCoupon {
    /**
     * 卡券基础信息，必填属性
     */
    @JSONField(name = "base_info")
    private final CouponBase couponBase;
    /**
     * 卡券高级信息，选填属性
     */
    @JSONField(name = "advanced_info")
    private CouponAdvance couponAdvanceInfo;

    /**
     * 卡券
     *
     * @param couponBaseInfo
     *            基础信息
     */
    protected CardCoupon(CouponBase couponBaseInfo) {
        this.couponBase = couponBaseInfo;
    }

    public  void cleanCantUpdateField(){
        this.couponBase.cleanCantUpdateField();
    }
    /**
     * 卡券类型
     *
     * @return
     */
    public abstract CardType getCardType();

    public CouponBase getCouponBaseInfo() {
        return couponBase;
    }

    public CouponAdvance getCouponAdvanceInfo() {
        return couponAdvanceInfo;
    }

    public void setCouponAdvanceInfo(CouponAdvance couponAdvanceInfo) {
        this.couponAdvanceInfo = couponAdvanceInfo;
    }

    @Override
    public String toString() {
        return "baseInfo=" + couponBase + ", advanceInfo="
                + couponAdvanceInfo + ", cardType=" + getCardType();
    }
}
