package cn.ipokerface.weixin.model;

import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinAccount implements Serializable {

    private static final long serialVersionUID = -6001008896414323534L;

    /**
     * 唯一的身份标识
     */
    private final String id;
    /**
     * 调用接口的密钥
     */
    private final String secret;

    @JSONCreator
    public WeixinAccount(@JSONField(name = "id") String id,
                         @JSONField(name = "secret") String secret) {
        this.id = id;
        this.secret = secret;
    }

    public String getId() {
        return id;
    }

    public String getSecret() {
        return secret;
    }

    @Override
    public String toString() {
        return "id=" + id + ", secret=" + secret;
    }
}