package cn.ipokerface.weixin.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class MemoryCacheStorager <T extends Cacheable> implements AbstractCacheStorager<T> {


    private final Map<String, T> content = new ConcurrentHashMap<String,T>();



    @Override
    public T lookup(String key) {
        T cache = this.content.get(key);
        if (cache != null) {
            if ((cache.createTime() + cache.expiredTime() - timeout) > System
                    .currentTimeMillis()) {
                return cache;
            }
        }
        return null;
    }

    @Override
    public void caching(String key, T cache) {
        this.content.put(key, cache);
    }

    @Override
    public T delete(String key) {
        return this.content.remove(key);
    }

    @Override
    public void clear() {
        this.content.clear();
    }
}
