package cn.ipokerface.weixin.cache;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface AbstractCacheStorager <T extends Cacheable> {

    public static final long timeout = 60 * 1000l;

    /**
     * get Value of key
     *
     * @param key key
     * @return value
     */
    T lookup(String key);

    /**
     * put value to key
     *
     * @param key key
     * @param cache value
     */
    void caching(String key, T cache);

    /**
     * remove value of key
     *
     * @param key key
     * @return value
     */
    T delete(String key);

    /**
     * remove all keys in cache
     */
    void clear();
}
