/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    private static final String yyyyMMdd = "yyyyMMdd";
    private static final String yyyy_MM_dd = "yyyy-MM-dd";
    private static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";

    public static String fortmat2yyyyMMdd(Date date) {
        return DateUtils.formatDate(date, yyyyMMdd);
    }

    public static String fortmat2yyyy_MM_dd(Date date) {
        return DateUtils.formatDate(date, yyyy_MM_dd);
    }

    public static String fortmat2yyyyMMddHHmmss(Date date) {
        return DateUtils.formatDate(date, yyyyMMddHHmmss);
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        return df.format(date);
    }

    public static Date parse2yyyyMMddHHmmss(String date) {
        return DateUtils.parseDate(date, yyyyMMddHHmmss);
    }

    public static Date parseDate(String date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String timestamp2string() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public static int formatYuan2Fen(double fee) {
        BigDecimal _fee = new BigDecimal(Double.toString(fee));
        return _fee.multiply(new BigDecimal("100")).setScale(0, 6).intValue();
    }

    public static double formatFee2Yuan(int fee) {
        BigDecimal _fee = new BigDecimal(Integer.toString(fee));
        return _fee.divide(new BigDecimal("100")).setScale(2, 6).doubleValue();
    }
}

