/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.simple;

import cn.ipokerface.weixin.request.http.AbstractHttpResponse;
import cn.ipokerface.weixin.request.http.HttpHeaders;
import cn.ipokerface.weixin.request.http.HttpStatus;
import cn.ipokerface.weixin.request.http.HttpVersion;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

public class SimpleHttpResponse
extends AbstractHttpResponse {
    private final HttpURLConnection connection;
    private HttpHeaders headers;
    private HttpVersion protocol;
    private HttpStatus status;

    public SimpleHttpResponse(HttpURLConnection connection, byte[] content) {
        super(content);
        this.connection = connection;
    }

    public HttpVersion getProtocol() {
        String version = this.connection.getHeaderField(null);
        if (version == null) {
            return null;
        }
        if (this.protocol == null) {
            if (version.contains("HTTP/1.0")) {
                this.protocol = HttpVersion.HTTP_1_0;
            } else if (version.contains("HTTP/1.1")) {
                this.protocol = HttpVersion.HTTP_1_1;
            } else {
                String connect = this.connection.getHeaderField("Connection");
                this.protocol = new HttpVersion(version, "keep-alive".equalsIgnoreCase(connect));
            }
        }
        return this.protocol;
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            Map<String, List<String>> headerFields = this.connection.getHeaderFields();
            for (Map.Entry<String, List<String>> headerEntry : headerFields.entrySet()) {
                this.headers.put(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        return this.headers;
    }

    public HttpStatus getStatus() {
        if (this.status == null) {
            try {
                this.status = new HttpStatus(this.connection.getResponseCode(), this.connection.getResponseMessage());
            }
            catch (IOException e) {
                throw new RuntimeException("I/O Error on getStatus", e);
            }
        }
        return this.status;
    }

    public void close() {
        this.connection.disconnect();
    }
}

