/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.netty;

import cn.ipokerface.weixin.request.http.HttpClient;
import cn.ipokerface.weixin.request.http.HttpClientFactory;
import cn.ipokerface.weixin.request.http.HttpParams;
import cn.ipokerface.weixin.request.http.netty.Netty4HttpClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Netty4HttpClientFactory
extends HttpClientFactory {
    private volatile Bootstrap bootstrap;
    private EventLoopGroup eventLoopGroup;
    private Map<ChannelOption<?>, ?> options;

    public Netty4HttpClientFactory() {
        this((EventLoopGroup)new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 4));
    }

    public Netty4HttpClientFactory(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public Netty4HttpClientFactory setOptions(Map<ChannelOption<?>, ?> options) {
        if (options == null) {
            throw new IllegalArgumentException("'options' must not be empty");
        }
        this.options = options;
        return this;
    }

    private Bootstrap getBootstrap(final HttpParams params) {
        if (this.bootstrap == null) {
            this.bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    ChannelPipeline pipeline = channel.pipeline();
                    if (params != null) {
                        channel.config().setConnectTimeoutMillis(params.getConnectTimeout());
                        if (Netty4HttpClientFactory.this.options != null) {
                            channel.config().setOptions(Netty4HttpClientFactory.this.options);
                        }
                        pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler((long)params.getReadTimeout(), TimeUnit.MILLISECONDS)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpResponseDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                }
            });
        }
        return this.bootstrap;
    }

    @Override
    public HttpClient newInstance(HttpParams params) {
        return new Netty4HttpClient(this.getBootstrap(params), params);
    }
}

