/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.message;

import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.MimeType;
import cn.ipokerface.weixin.request.http.message.AbstractMessageConverter;
import cn.ipokerface.weixin.utils.FileUtils;
import cn.ipokerface.weixin.utils.IOUtils;
import cn.ipokerface.weixin.utils.RegexUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMessageConverter
extends AbstractMessageConverter {
    public static final JsonMessageConverter GLOBAL = new JsonMessageConverter();
    private static final String JSO = "json";
    private static final int BRACE = 0x8000000;
    private static final int BRACKET = 0x8000000;
    private static final int MASK = 0x8000000;

    public JsonMessageConverter() {
        super(MimeType.APPLICATION_JSON, MimeType.TEXT_JSON, new MimeType("application", "*+json"));
    }

    @Override
    public boolean canConvert(Class<?> clazz, HttpResponse response) {
        if (!super.canConvert(clazz, response)) {
            String disposition = response.getHeaders().getFirst("Content-Disposition");
            String fileName = RegexUtil.regexFileNameFromContentDispositionHeader(disposition);
            return fileName != null && FileUtils.getFileExtension(fileName).equalsIgnoreCase(JSO);
        }
        return true;
    }

    @Override
    protected boolean supports(Class<?> clazz, byte[] content) {
        return (0x8000000 & 1 << content[0]) != 0;
    }

    @Override
    protected <T> T convertInternal(Class<? extends T> clazz, InputStream body) throws IOException {
        byte[] bytes = IOUtils.toByteArray(body);
        return (T)JSON.parseObject((byte[])bytes, (int)0, (int)bytes.length, (CharsetDecoder)this.charset.newDecoder(), clazz, (Feature[])new Feature[0]);
    }
}

