/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.entity;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.request.http.ContentType;
import cn.ipokerface.weixin.request.http.entity.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StringEntity
implements HttpEntity {
    private final byte[] content;
    private final ContentType contentType;

    public StringEntity(String body) {
        this(body, ContentType.DEFAULT_TEXT);
    }

    public StringEntity(String body, ContentType contentType) {
        this.content = body.getBytes(contentType.getCharset());
        this.contentType = contentType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.content.length;
    }

    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.content);
        outstream.flush();
    }

    public String getContentString() {
        return new String(this.content, Constant.UTF_8);
    }
}

