/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.apache;

import cn.ipokerface.weixin.request.http.ContentType;
import cn.ipokerface.weixin.request.http.apache.AbstractMultipartForm;
import cn.ipokerface.weixin.request.http.entity.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MultipartFormEntity
implements HttpEntity {
    private final AbstractMultipartForm multipart;
    private final ContentType contentType;
    private final long contentLength;

    MultipartFormEntity(AbstractMultipartForm multipart, ContentType contentType, long contentLength) {
        this.multipart = multipart;
        this.contentType = contentType;
        this.contentLength = contentLength;
    }

    AbstractMultipartForm getMultipart() {
        return this.multipart;
    }

    public boolean isRepeatable() {
        return this.contentLength != -1L;
    }

    public boolean isChunked() {
        return !this.isRepeatable();
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public InputStream getContent() throws IOException {
        if (this.contentLength < 0L) {
            throw new IllegalArgumentException("Content length is unknown");
        }
        if (this.contentLength > 0x500000L) {
            throw new IllegalArgumentException("Content length is too long: " + this.contentLength);
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.writeTo(outstream);
        outstream.flush();
        return new ByteArrayInputStream(outstream.toByteArray());
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.multipart.writeTo(outstream);
    }
}

