/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http;

import cn.ipokerface.weixin.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MimeType
implements Serializable {
    private static final long serialVersionUID = 4430596628682058362L;
    private static final String WILDCARD_TYPE = "*";
    private final String type;
    private final String subType;
    public static final MimeType APPLICATION_FORM_URLENCODED = MimeType.valueOf("application/x-www-form-urlencoded");
    public static final MimeType APPLICATION_JSON = MimeType.valueOf("application/json");
    public static final MimeType APPLICATION_OCTET_STREAM = MimeType.valueOf("application/octet-stream");
    public static final MimeType APPLICATION_XML = MimeType.valueOf("application/xml");
    public static final MimeType MULTIPART_FORM_DATA = MimeType.valueOf("multipart/form-data");
    public static final MimeType TEXT_HTML = MimeType.valueOf("text/html");
    public static final MimeType TEXT_PLAIN = MimeType.valueOf("text/plain");
    public static final MimeType IMAGE_JPG = MimeType.valueOf("image/jpg");
    public static final MimeType AUDIO_MP3 = MimeType.valueOf("audio/mp3");
    public static final MimeType VIDEO_MPEG4 = MimeType.valueOf("video/mpeg4");
    public static final MimeType TEXT_XML = MimeType.valueOf("text/xml");
    public static final MimeType TEXT_JSON = MimeType.valueOf("text/json");
    public static final List<MimeType> STREAM_MIMETYPES = new ArrayList<MimeType>(4);

    public MimeType(String type) {
        this(type, WILDCARD_TYPE);
    }

    public MimeType(String type, String subType) {
        this.type = type.toLowerCase(Locale.ENGLISH);
        this.subType = subType.toLowerCase(Locale.ENGLISH);
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean isWildcardType() {
        return WILDCARD_TYPE.equals(this.getType());
    }

    public boolean isWildcardSubtype() {
        return WILDCARD_TYPE.equals(this.getSubType()) || this.getSubType().startsWith("*+");
    }

    public static MimeType valueOf(String value) {
        int subIndex;
        if (StringUtil.isBlank(value)) {
            return null;
        }
        String mimeType = StringUtil.tokenizeToStringArray(value, ";")[0].trim().toLowerCase(Locale.ENGLISH);
        if (WILDCARD_TYPE.equals(mimeType)) {
            mimeType = "*/*";
        }
        if ((subIndex = mimeType.indexOf(47)) == -1) {
            throw new IllegalArgumentException(mimeType + ":does not contain '/'");
        }
        if (subIndex == mimeType.length() - 1) {
            throw new IllegalArgumentException(mimeType + ":does not contain subtype after '/'");
        }
        String type = mimeType.substring(0, subIndex);
        String subType = mimeType.substring(subIndex + 1, mimeType.length());
        if (WILDCARD_TYPE.equals(type) && !WILDCARD_TYPE.equals(subType)) {
            throw new IllegalArgumentException(mimeType + ":wildcard type is legal only in '*/*' (all mime types)");
        }
        return new MimeType(type, subType);
    }

    public boolean includes(MimeType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType()) {
            return true;
        }
        if (this.getType().equals(other.getType())) {
            if (this.getSubType().equals(other.getSubType())) {
                return true;
            }
            if (this.isWildcardSubtype()) {
                int thisPlusIdx = this.getSubType().indexOf(43);
                if (thisPlusIdx == -1) {
                    return true;
                }
                int otherPlusIdx = other.getSubType().indexOf(43);
                if (otherPlusIdx != -1) {
                    String otherSubtypeSuffix;
                    String thisSubtypeNoSuffix = this.getSubType().substring(0, thisPlusIdx);
                    String thisSubtypeSuffix = this.getSubType().substring(thisPlusIdx + 1);
                    if (thisSubtypeSuffix.equals(otherSubtypeSuffix = other.getSubType().substring(otherPlusIdx + 1)) && WILDCARD_TYPE.equals(thisSubtypeNoSuffix)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public String toString() {
        return String.format("%s/%s", this.type, this.subType);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MimeType)) {
            return false;
        }
        MimeType otherType = (MimeType)other;
        return this.type.equalsIgnoreCase(otherType.type) && this.subType.equalsIgnoreCase(otherType.subType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subType == null ? 0 : this.subType.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    static {
        STREAM_MIMETYPES.add(APPLICATION_OCTET_STREAM);
        STREAM_MIMETYPES.add(MimeType.valueOf("image/*"));
        STREAM_MIMETYPES.add(MimeType.valueOf("audio/*"));
        STREAM_MIMETYPES.add(MimeType.valueOf("video/*"));
        STREAM_MIMETYPES.add(MimeType.valueOf("application/zip"));
        STREAM_MIMETYPES.add(MimeType.valueOf("application/x-gzip"));
    }
}

