/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http;

import cn.ipokerface.weixin.request.http.HttpClient;
import cn.ipokerface.weixin.request.http.HttpClientException;
import cn.ipokerface.weixin.request.http.HttpHeaders;
import cn.ipokerface.weixin.request.http.HttpMethod;
import cn.ipokerface.weixin.request.http.HttpRequest;
import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.HttpStatus;
import cn.ipokerface.weixin.request.http.MimeType;
import cn.ipokerface.weixin.request.http.URLParameter;
import cn.ipokerface.weixin.request.http.entity.FormUrlEntity;
import cn.ipokerface.weixin.request.http.entity.HttpEntity;
import java.util.Arrays;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpClient
implements HttpClient {
    @Override
    public HttpResponse get(String url) throws HttpClientException {
        return this.execute(HttpMethod.GET, url);
    }

    @Override
    public HttpResponse get(String url, URLParameter ... parameters) throws HttpClientException {
        return this.execute(HttpMethod.GET, url, parameters);
    }

    @Override
    public HttpHeaders head(String url) throws HttpClientException {
        return this.head(url, null);
    }

    @Override
    public HttpHeaders head(String url, URLParameter ... parameters) throws HttpClientException {
        return this.execute(HttpMethod.HEAD, url, parameters).getHeaders();
    }

    @Override
    public HttpResponse post(String url) throws HttpClientException {
        return this.execute(HttpMethod.POST, url);
    }

    @Override
    public HttpResponse post(String url, URLParameter ... parameters) throws HttpClientException {
        FormUrlEntity entity = null;
        if (parameters != null && parameters.length > 0) {
            entity = new FormUrlEntity(Arrays.asList(parameters));
        }
        return this.post(url, entity);
    }

    @Override
    public HttpResponse post(String url, HttpEntity entity) throws HttpClientException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(entity);
        return this.execute(request);
    }

    @Override
    public void put(String url) throws HttpClientException {
        this.execute(HttpMethod.PUT, url);
    }

    @Override
    public void put(String url, URLParameter ... parameters) throws HttpClientException {
        this.execute(HttpMethod.PUT, url, parameters);
    }

    @Override
    public void delete(String url) throws HttpClientException {
        this.execute(HttpMethod.DELETE, url);
    }

    @Override
    public void delete(String url, URLParameter ... parameters) throws HttpClientException {
        this.execute(HttpMethod.DELETE, url, parameters);
    }

    @Override
    public Set<HttpMethod> options(String url) throws HttpClientException {
        return this.options(url, null);
    }

    @Override
    public Set<HttpMethod> options(String url, URLParameter ... parameters) throws HttpClientException {
        HttpHeaders headers = this.execute(HttpMethod.OPTIONS, url, parameters).getHeaders();
        return headers.getAllow();
    }

    protected HttpResponse execute(HttpMethod method, String url) throws HttpClientException {
        return this.execute(new HttpRequest(method, url));
    }

    protected HttpResponse execute(HttpMethod method, String url, URLParameter ... parameters) throws HttpClientException {
        StringBuilder buf = new StringBuilder(url);
        if (parameters != null && parameters.length > 0) {
            if (url.indexOf("?") < 0) {
                buf.append("?");
            } else {
                buf.append("&");
            }
            buf.append(FormUrlEntity.formatParameters(Arrays.asList(parameters)));
        }
        return this.execute(new HttpRequest(method, buf.toString()));
    }

    protected boolean hasError(HttpStatus status) {
        return status.series() == HttpStatus.Series.CLIENT_ERROR || status.series() == HttpStatus.Series.SERVER_ERROR;
    }

    protected void handleResponse(HttpResponse response) throws HttpClientException {
        HttpStatus status = response.getStatus();
        HttpHeaders headers = response.getHeaders();
        MimeType resultType = MimeType.valueOf(headers.getFirst("Content-Type"));
        if (!MimeType.APPLICATION_JSON.includes(resultType) && this.hasError(status)) {
            switch (status.series()) {
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    throw new HttpClientException(String.format("%d %s", status.getStatusCode(), status.getStatusText()));
                }
            }
            throw new HttpClientException("Unknown status code [" + status + "]");
        }
    }
}

