/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy.redpack;

import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.proxy.redpack.RedPacketRisk;
import cn.ipokerface.weixin.proxy.redpack.RedpacketSceneType;
import cn.ipokerface.weixin.utils.DateUtils;
import com.alibaba.fastjson.annotation.JSONField;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RedPacket
extends MerchantResult {
    private static final long serialVersionUID = -7021352305575714281L;
    @XmlElement(name="mch_billno")
    @JSONField(name="mch_billno")
    private String outTradeNo;
    @XmlElement(name="re_openid")
    @JSONField(name="re_openid")
    private String openId;
    @XmlElement(name="send_name")
    @JSONField(name="send_name")
    private String sendName;
    @XmlElement(name="total_amount")
    @JSONField(name="total_amount")
    private int totalAmount;
    @XmlElement(name="total_num")
    @JSONField(name="total_num")
    private int totalNum;
    @XmlElement(name="amt_type")
    @JSONField(name="amt_type")
    private String amtType;
    private String wishing;
    @XmlElement(name="client_ip")
    @JSONField(name="client_ip")
    private String clientIp;
    @XmlElement(name="act_name")
    @JSONField(name="act_name")
    private String actName;
    private String remark;
    @XmlElement(name="msgappid")
    @JSONField(name="msgappid")
    private String msgAppId;
    @XmlElement(name="consume_mch_id")
    @JSONField(name="consume_mch_id")
    private String consumeMchId;
    @XmlElement(name="scene_id")
    @JSONField(name="scene_id")
    private RedpacketSceneType sceneType;
    @XmlElement(name="risk_info")
    @JSONField(name="risk_info")
    private String risk;

    protected RedPacket() {
    }

    public RedPacket(String outTradeNo, String openId, String sendName, double totalAmount, int totalNum, String wishing, String clientIp, String actName, String remark) {
        this.outTradeNo = outTradeNo;
        this.openId = openId;
        this.sendName = sendName;
        this.totalAmount = DateUtils.formatYuan2Fen(totalAmount);
        this.totalNum = totalNum;
        this.wishing = wishing;
        this.clientIp = clientIp;
        this.actName = actName;
        this.remark = remark;
        this.amtType = totalNum > 1 ? "ALL_RAND" : null;
    }

    public RedPacket copy(String outTradeNo, String openId) {
        RedPacket readpacket = new RedPacket(outTradeNo, openId, this.sendName, this.totalAmount, this.totalNum, this.wishing, this.clientIp, this.actName, this.remark);
        readpacket.setMsgAppId(this.msgAppId);
        readpacket.setConsumeMchId(this.consumeMchId);
        readpacket.setSceneType(this.sceneType);
        readpacket.setRisk(this.risk);
        return readpacket;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getSendName() {
        return this.sendName;
    }

    public int getTotalAmount() {
        return this.totalAmount;
    }

    @JSONField(serialize=false)
    public double getFormatTotalAmount() {
        return (double)this.totalAmount / 100.0;
    }

    public int getTotalNum() {
        return this.totalNum;
    }

    public String getWishing() {
        return this.wishing;
    }

    public String getAmtType() {
        return this.amtType;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getActName() {
        return this.actName;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getMsgAppId() {
        return this.msgAppId;
    }

    public void setMsgAppId(String msgAppId) {
        this.msgAppId = msgAppId;
    }

    public String getConsumeMchId() {
        return this.consumeMchId;
    }

    public void setConsumeMchId(String consumeMchId) {
        this.consumeMchId = consumeMchId;
    }

    public RedpacketSceneType getSceneType() {
        return this.sceneType;
    }

    public void setSceneType(RedpacketSceneType sceneType) {
        this.sceneType = sceneType;
    }

    public String getRisk() {
        return this.risk;
    }

    public void setRisk(String risk) {
        this.risk = risk;
    }

    public void setRisk(RedPacketRisk risk) {
        this.risk = risk.toContent();
    }

    public String toString() {
        return "Redpacket [outTradeNo=" + this.outTradeNo + ", openId=" + this.openId + ", sendName=" + this.sendName + ", totalAmount=" + this.totalAmount + ", totalNum=" + this.totalNum + ", amtType=" + this.amtType + ", wishing=" + this.wishing + ", clientIp=" + this.clientIp + ", actName=" + this.actName + ", remark=" + this.remark + ", msgAppId=" + this.msgAppId + ", consumeMchId=" + this.consumeMchId + ", sceneType=" + (Object)((Object)this.sceneType) + ", risk=" + this.risk + ", " + super.toString() + "]";
    }
}

