/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.sign.WeixinPaymentSignature;
import cn.ipokerface.weixin.utils.RandomUtil;
import com.alibaba.fastjson.annotation.JSONField;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NativePaymentResponse
extends MerchantResult {
    private static final long serialVersionUID = 6119895998783333012L;
    @XmlElement(name="prepay_id")
    @JSONField(name="prepay_id")
    private String prepayId;

    protected NativePaymentResponse() {
    }

    public NativePaymentResponse(String returnMsg, String resultMsg) {
        super("FAIL", returnMsg);
        super.setErrCodeDes(resultMsg);
        super.setResultCode("FAIL");
    }

    public NativePaymentResponse(WeixinPayAccount weixinAccount, String prepayId) {
        super("SUCCESS", "OK");
        this.setResultCode("SUCCESS");
        this.setMchId(weixinAccount.getMchId());
        this.setAppId(weixinAccount.getId());
        this.setNonceStr(RandomUtil.generateString(16));
        this.prepayId = prepayId;
        this.setSign(new WeixinPaymentSignature(weixinAccount.getPaySignKey()).sign(this));
    }

    public String getPrepayId() {
        return this.prepayId;
    }

    public String toString() {
        return "NativePayResponse [prepayId=" + this.prepayId + ", " + super.toString() + "]";
    }
}

