/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.payment.TradeType;
import cn.ipokerface.weixin.proxy.payment.AbstractPaymentRequest;
import cn.ipokerface.weixin.proxy.payment.PaymentRequest;
import cn.ipokerface.weixin.sign.SignType;
import cn.ipokerface.weixin.utils.DigestUtils;
import cn.ipokerface.weixin.utils.MapUtils;
import java.util.HashMap;

public class AppPaymentRequest
extends AbstractPaymentRequest {
    public AppPaymentRequest(String prePayId, WeixinPayAccount payAccount) {
        super(prePayId, payAccount);
    }

    public TradeType getPaymentType() {
        return TradeType.APP;
    }

    public PaymentRequest toRequestObject() {
        PaymentRequest payRequest = new PaymentRequest(this.getPaymentAccount().getId(), "Sign=WXPay");
        payRequest.setPartnerId(this.getPaymentAccount().getMchId());
        payRequest.setPrepayId(this.getPrePayId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", payRequest.getAppId());
        map.put("partnerid", payRequest.getPartnerId());
        map.put("prepayid", payRequest.getPrepayId());
        map.put("package", payRequest.getPackageInfo());
        map.put("timestamp", payRequest.getTimeStamp());
        map.put("noncestr", payRequest.getNonceStr());
        String sign = DigestUtils.MD5(String.format("%s&key=%s", MapUtils.toJoinString(map, false, true), this.getPaymentAccount().getPaySignKey())).toUpperCase();
        payRequest.setPaySign(sign);
        payRequest.setSignType(SignType.MD5);
        return payRequest;
    }

    public String toRequestString() {
        PaymentRequest payRequest = this.toRequestObject();
        StringBuilder content = new StringBuilder();
        content.append("<xml>");
        content.append(String.format("<appid><![CDATA[%s]]></appid>", payRequest.getAppId()));
        content.append(String.format("<partnerid><![CDATA[%s]]></partnerid>", payRequest.getPartnerId()));
        content.append(String.format("<prepayid><![CDATA[%s]]></prepayid>", payRequest.getPrepayId()));
        content.append(String.format("<package><![CDATA[%s]]></package>", payRequest.getPackageInfo()));
        content.append(String.format("<noncestr><![CDATA[%s]]></noncestr>", payRequest.getNonceStr()));
        content.append(String.format("<timestamp><![CDATA[%s]]></timestamp>", payRequest.getTimeStamp()));
        content.append(String.format("<sign><![CDATA[%s]]></sign>", payRequest.getPaySign()));
        content.append("</xml>");
        return content.toString();
    }
}

