/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy.company;

import cn.ipokerface.weixin.proxy.company.CompanyPaymentCheckNameType;
import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.utils.DateUtils;
import com.alibaba.fastjson.annotation.JSONField;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CompanyPayment
extends MerchantResult {
    private static final long serialVersionUID = 3734639674346425312L;
    @XmlElement(name="partner_trade_no")
    @JSONField(name="partner_trade_no")
    private String outTradeNo;
    @JSONField(name="openid")
    @XmlElement(name="openid")
    private String openId;
    @XmlElement(name="check_name")
    @JSONField(name="check_name")
    private CompanyPaymentCheckNameType checkNameType;
    @XmlElement(name="re_user_name")
    @JSONField(name="re_user_name")
    private String userName;
    private String desc;
    private int amount;
    @XmlElement(name="spbill_create_ip")
    @JSONField(name="spbill_create_ip")
    private String clientIp;

    protected CompanyPayment() {
    }

    public CompanyPayment(String outTradeNo, String openId, CompanyPaymentCheckNameType checkNameType, String desc, double amount, String clientIp) {
        this.outTradeNo = outTradeNo;
        this.openId = openId;
        this.checkNameType = checkNameType;
        this.desc = desc;
        this.amount = DateUtils.formatYuan2Fen(amount);
        this.clientIp = clientIp;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getOpenId() {
        return this.openId;
    }

    public CompanyPaymentCheckNameType getCheckNameType() {
        return this.checkNameType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getAmount() {
        return this.amount;
    }

    @JSONField(serialize=false)
    public double getFormatAmount() {
        return (double)this.amount / 100.0;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String toString() {
        return "CorpPayment [outTradeNo=" + this.outTradeNo + ", openId=" + this.openId + ", checkNameType=" + (Object)((Object)this.checkNameType) + ", userName=" + this.userName + ", desc=" + this.desc + ", amount=" + this.amount + ", clientIp=" + this.clientIp + ", " + super.toString() + "]";
    }
}

