/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.custom.CustomCity;
import cn.ipokerface.weixin.model.page.Pageable;
import cn.ipokerface.weixin.proxy.CashProxy;
import cn.ipokerface.weixin.proxy.CouponProxy;
import cn.ipokerface.weixin.proxy.OrderProxy;
import cn.ipokerface.weixin.proxy.PaymentProxy;
import cn.ipokerface.weixin.proxy.company.CompanyPayment;
import cn.ipokerface.weixin.proxy.company.CompanyPaymentRecord;
import cn.ipokerface.weixin.proxy.company.CompanyPaymentResult;
import cn.ipokerface.weixin.proxy.coupon.CouponDetail;
import cn.ipokerface.weixin.proxy.coupon.CouponResult;
import cn.ipokerface.weixin.proxy.coupon.CouponStock;
import cn.ipokerface.weixin.proxy.merchant.BillType;
import cn.ipokerface.weixin.proxy.merchant.CurrencyType;
import cn.ipokerface.weixin.proxy.merchant.IdQuery;
import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.proxy.merchant.Order;
import cn.ipokerface.weixin.proxy.merchant.ZipType;
import cn.ipokerface.weixin.proxy.order.CustomOrder;
import cn.ipokerface.weixin.proxy.order.CustomOrderRecord;
import cn.ipokerface.weixin.proxy.order.CustomOrderResult;
import cn.ipokerface.weixin.proxy.payment.MerchantPaymentPackage;
import cn.ipokerface.weixin.proxy.payment.MerchantPaymentRequest;
import cn.ipokerface.weixin.proxy.payment.NativePaymentResponse;
import cn.ipokerface.weixin.proxy.payment.OpenidResult;
import cn.ipokerface.weixin.proxy.payment.PrePayment;
import cn.ipokerface.weixin.proxy.payment.SceneInfoApp;
import cn.ipokerface.weixin.proxy.payment.SceneInfoStore;
import cn.ipokerface.weixin.proxy.redpack.RedPacket;
import cn.ipokerface.weixin.proxy.redpack.RedPacketRecord;
import cn.ipokerface.weixin.proxy.redpack.RedPacketSendResult;
import cn.ipokerface.weixin.proxy.refund.RefundAccountType;
import cn.ipokerface.weixin.proxy.refund.RefundRecord;
import cn.ipokerface.weixin.proxy.refund.RefundResult;
import cn.ipokerface.weixin.proxy.settle.SettlementRecord;
import cn.ipokerface.weixin.request.ApiXmlResult;
import cn.ipokerface.weixin.sign.WeixinSignature;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeixinPaymentProxy {
    private final PaymentProxy paymentProxy;
    private final CouponProxy couponProxy;
    private final CashProxy cashProxy;
    private final OrderProxy orderProxy;
    private final WeixinPayAccount weixinPayAccount;

    public WeixinPaymentProxy(WeixinPayAccount weixinPayAccount) {
        if (weixinPayAccount == null) {
            throw new IllegalArgumentException("weixinPayAccount must not be empty");
        }
        this.weixinPayAccount = weixinPayAccount;
        this.paymentProxy = new PaymentProxy(weixinPayAccount);
        this.couponProxy = new CouponProxy(weixinPayAccount);
        this.cashProxy = new CashProxy(weixinPayAccount);
        this.orderProxy = new OrderProxy(weixinPayAccount);
    }

    public WeixinPayAccount getWeixinPayAccount() {
        return this.weixinPayAccount;
    }

    public WeixinSignature getWeixinSignature() {
        return this.paymentProxy.getWeixinSignature();
    }

    public PrePayment createPrePay(MerchantPaymentPackage payPackage) throws WeixinException {
        return this.paymentProxy.createPrePay(payPackage);
    }

    public MerchantPaymentRequest createPayRequest(MerchantPaymentPackage payPackage) throws WeixinException {
        return this.paymentProxy.createPayRequest(payPackage);
    }

    public MerchantPaymentRequest createJSPayRequest(String openId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.paymentProxy.createJSPayRequest(openId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public String createAddressRequestJSON(String url, String oauthToken) {
        return this.paymentProxy.createAddressRequestJSON(url, oauthToken);
    }

    public String createNativePayRequest(String productId) {
        return this.paymentProxy.createNativePayRequest(productId);
    }

    public NativePaymentResponse createNativePayResponse(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.paymentProxy.createNativePayResponse(productId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MerchantPaymentRequest createNativePayRequest(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.paymentProxy.createNativePayRequest(productId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MerchantPaymentRequest createAppPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach, SceneInfoStore store) throws WeixinException {
        return this.paymentProxy.createAppPayRequest(body, outTradeNo, totalFee, notifyUrl, createIp, attach, store);
    }

    public MerchantPaymentRequest createWapPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach, SceneInfoApp app) throws WeixinException {
        return this.paymentProxy.createWapPayRequest(body, outTradeNo, totalFee, notifyUrl, createIp, attach, app);
    }

    public MerchantPaymentRequest createMicroPayRequest(String authCode, String body, String outTradeNo, double totalFee, String createIp, String attach, SceneInfoStore store) throws WeixinException {
        return this.paymentProxy.createMicroPayRequest(authCode, body, outTradeNo, totalFee, createIp, attach, store);
    }

    public Order queryOrder(IdQuery idQuery) throws WeixinException {
        return this.paymentProxy.queryOrder(idQuery);
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee, double refundFee, CurrencyType refundFeeType, String opUserId, String refundDesc, RefundAccountType refundAccountType) throws WeixinException {
        return this.paymentProxy.applyRefund(idQuery, outRefundNo, totalFee, refundFee, refundFeeType, opUserId, refundDesc, refundAccountType);
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee) throws WeixinException {
        return this.paymentProxy.applyRefund(idQuery, outRefundNo, totalFee);
    }

    public RefundRecord queryRefund(IdQuery idQuery) throws WeixinException {
        return this.paymentProxy.queryRefund(idQuery);
    }

    public void downloadBill(Date billDate, BillType billType, OutputStream outputStream, ZipType tarType) throws WeixinException {
        this.paymentProxy.downloadBill(billDate, billType, outputStream, tarType);
    }

    public MerchantResult reverseOrder(IdQuery idQuery) throws WeixinException {
        return this.paymentProxy.reverseOrder(idQuery);
    }

    public MerchantResult closeOrder(String outTradeNo) throws WeixinException {
        return this.paymentProxy.closeOrder(outTradeNo);
    }

    public String getPayShorturl(String url) throws WeixinException {
        return this.paymentProxy.getShorturl(url);
    }

    public ApiXmlResult reportInterface(String interfaceUrl, int executeTime, String outTradeNo, String ip, Date time, ApiXmlResult returnXml) throws WeixinException {
        return this.paymentProxy.reportInterface(interfaceUrl, executeTime, outTradeNo, ip, time, returnXml);
    }

    public CouponResult sendCoupon(String couponStockId, String partnerTradeNo, String openId, String opUserId) throws WeixinException {
        return this.couponProxy.sendCoupon(couponStockId, partnerTradeNo, openId, opUserId);
    }

    public CouponStock queryCouponStock(String couponStockId) throws WeixinException {
        return this.couponProxy.queryCouponStock(couponStockId);
    }

    public CouponDetail queryCouponDetail(String openId, String couponId, String stockId) throws WeixinException {
        return this.couponProxy.queryCouponDetail(openId, couponId, stockId);
    }

    public RedPacketSendResult sendRedpack(RedPacket redpacket) throws WeixinException {
        return this.cashProxy.sendRedpack(redpacket);
    }

    public List<Future<RedPacketSendResult>> sendRedpacks(RedPacket ... redpackets) {
        return this.cashProxy.sendRedpacks(redpackets);
    }

    public RedPacketRecord queryRedpack(String outTradeNo) throws WeixinException {
        return this.cashProxy.queryRedpack(outTradeNo);
    }

    public CompanyPaymentResult sendCorpPayment(CompanyPayment payment) throws WeixinException {
        return this.cashProxy.sendCorpPayment(payment);
    }

    public CompanyPaymentRecord queryCorpPayment(String outTradeNo) throws WeixinException {
        return this.cashProxy.queryCorpPayment(outTradeNo);
    }

    public OpenidResult authCode2openId(String authCode) throws WeixinException {
        return this.paymentProxy.authCode2openId(authCode);
    }

    public SettlementRecord querySettlement(boolean status, Pageable pageable, Date start, Date end) throws WeixinException {
        return this.cashProxy.querySettlement(status, pageable, start, end);
    }

    public double queryExchageRate(CurrencyType currencyType, Date date) throws WeixinException {
        return this.cashProxy.queryExchageRate(currencyType, date);
    }

    public CustomOrderResult declareCustomsOrder(CustomOrder customsOrder) throws WeixinException {
        return this.orderProxy.declareCustomsOrder(customsOrder);
    }

    public CustomOrderRecord queryCustomsOrder(IdQuery idQuery, CustomCity customsCity) throws WeixinException {
        return this.orderProxy.queryCustomsOrder(idQuery, customsCity);
    }
}

