/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.custom.CustomCity;
import cn.ipokerface.weixin.proxy.MerchantProxy;
import cn.ipokerface.weixin.proxy.merchant.IdQuery;
import cn.ipokerface.weixin.proxy.order.CustomOrder;
import cn.ipokerface.weixin.proxy.order.CustomOrderRecord;
import cn.ipokerface.weixin.proxy.order.CustomOrderResult;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.xml.ListSuffixResultDeserializer;
import cn.ipokerface.weixin.xml.XmlFormatter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

public class OrderProxy
extends MerchantProxy {
    public OrderProxy(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }

    public CustomOrderResult declareCustomsOrder(CustomOrder customsOrder) throws WeixinException {
        JSONObject para = (JSONObject)JSON.toJSON((Object)customsOrder);
        para.put("appid", (Object)this.weixinPayAccount.getId());
        para.put("mch_id", (Object)this.weixinPayAccount.getMchId());
        para.put("sign", (Object)this.weixinSignature.sign(para));
        String param = XmlFormatter.map2xml(para);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/mch/customs/customdeclareorder", param);
        return response.getAsObject(new TypeReference<CustomOrderResult>(){});
    }

    public CustomOrderRecord queryCustomsOrder(IdQuery idQuery, CustomCity customsCity) throws WeixinException {
        JSONObject para = new JSONObject();
        para.put("appid", (Object)this.weixinPayAccount.getId());
        para.put("mch_id", (Object)this.weixinPayAccount.getMchId());
        para.put(idQuery.getType().getName(), (Object)idQuery.getId());
        para.put("customs", (Object)customsCity.name());
        para.put("sign", (Object)this.weixinSignature.sign(para));
        String param = XmlFormatter.map2xml(para);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/mch/customs/customdeclarequery", param);
        return ListSuffixResultDeserializer.deserialize(response.getAsString(), CustomOrderRecord.class);
    }
}

