/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.proxy.AbstractProxy;
import cn.ipokerface.weixin.proxy.merchant.IdQuery;
import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.request.WeixinRequestClient;
import cn.ipokerface.weixin.sign.WeixinPaymentSignature;
import cn.ipokerface.weixin.sign.WeixinSignature;
import cn.ipokerface.weixin.utils.RandomUtil;
import cn.ipokerface.weixin.utils.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MerchantProxy
extends AbstractProxy {
    protected final WeixinPayAccount weixinPayAccount;
    protected final WeixinSignature weixinSignature;
    private volatile WeixinRequestClient weixinSslRequestClient;

    public MerchantProxy(WeixinPayAccount payAccount) {
        this.weixinPayAccount = payAccount;
        this.weixinSignature = new WeixinPaymentSignature(this.weixinPayAccount.getPaySignKey());
    }

    public WeixinSignature getWeixinSignature() {
        return this.weixinSignature;
    }

    protected Map<String, String> createBaseRequestMap(IdQuery idQuery) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", this.weixinPayAccount.getId());
        map.put("mch_id", this.weixinPayAccount.getMchId());
        map.put("nonce_str", RandomUtil.generateString(16));
        if (StringUtil.isNotBlank(this.weixinPayAccount.getDeviceInfo())) {
            map.put("device_info", this.weixinPayAccount.getDeviceInfo());
        }
        if (StringUtil.isNotBlank(this.weixinPayAccount.getSubId())) {
            map.put("sub_appid", this.weixinPayAccount.getSubId());
        }
        if (StringUtil.isNotBlank(this.weixinPayAccount.getSubMchId())) {
            map.put("sub_mch_id", this.weixinPayAccount.getSubMchId());
        }
        if (idQuery != null) {
            map.put(idQuery.getType().getName(), idQuery.getId());
        }
        return map;
    }

    protected WeixinRequestClient getWeixinSSLExecutor() throws WeixinException {
        if (this.weixinSslRequestClient == null) {
            try {
                InputStream is = null;
                File certificate = new File(this.weixinPayAccount.getCertificateFile());
                is = !certificate.exists() || !certificate.isFile() ? Thread.currentThread().getContextClassLoader().getResourceAsStream(certificate.getName()) : new FileInputStream(certificate);
                if (is == null) {
                    throw new WeixinException("Invalid certificate file : " + certificate.toString());
                }
                this.weixinSslRequestClient = this.weixinRequestClient.createSSLRequestExecutor(this.weixinPayAccount.getCertificateKey(), is);
            }
            catch (IOException e) {
                throw new WeixinException("IO Error on createSSLRequestExecutor", e);
            }
        }
        return this.weixinSslRequestClient;
    }

    protected <T extends MerchantResult> void declareMerchant(T merchant) {
        merchant.setAppId(this.weixinPayAccount.getId());
        merchant.setMchId(this.weixinPayAccount.getMchId());
        merchant.setDeviceInfo(this.weixinPayAccount.getDeviceInfo());
        merchant.setSubAppId(this.weixinPayAccount.getSubId());
        merchant.setSubMchId(this.weixinPayAccount.getSubMchId());
        merchant.setNonceStr(RandomUtil.generateString(16));
    }
}

