/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.page.Pageable;
import cn.ipokerface.weixin.proxy.MerchantProxy;
import cn.ipokerface.weixin.proxy.company.CompanyPayment;
import cn.ipokerface.weixin.proxy.company.CompanyPaymentRecord;
import cn.ipokerface.weixin.proxy.company.CompanyPaymentResult;
import cn.ipokerface.weixin.proxy.merchant.CurrencyType;
import cn.ipokerface.weixin.proxy.redpack.RedPacket;
import cn.ipokerface.weixin.proxy.redpack.RedPacketRecord;
import cn.ipokerface.weixin.proxy.redpack.RedPacketSendResult;
import cn.ipokerface.weixin.proxy.settle.SettlementRecord;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.utils.DateUtils;
import cn.ipokerface.weixin.utils.RandomUtil;
import cn.ipokerface.weixin.utils.StringUtil;
import cn.ipokerface.weixin.xml.XmlFormatter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CashProxy
extends MerchantProxy {
    public CashProxy(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }

    public RedPacketSendResult sendRedpack(RedPacket redpacket) throws WeixinException {
        String appId = redpacket.getAppId();
        super.declareMerchant(redpacket);
        JSONObject obj = (JSONObject)JSON.toJSON((Object)redpacket);
        if (StringUtil.isNotBlank(appId)) {
            obj.put("appid", (Object)appId);
        }
        obj.put("wxappid", obj.remove((Object)"appid"));
        String redpack_uri = redpacket.getTotalNum() > 1 ? "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack" : "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlFormatter.map2xml(obj);
        WeixinResponse response = this.getWeixinSSLExecutor().post(redpack_uri, param);
        String text = response.getAsString().replaceFirst("<wxappid>", "<appid>").replaceFirst("</wxappid>", "</appid>");
        return XmlFormatter.fromXML(text, RedPacketSendResult.class);
    }

    public List<Future<RedPacketSendResult>> sendRedpacks(RedPacket ... redPackets) {
        ExecutorService sendExecutor = Executors.newFixedThreadPool(Math.max(1, redPackets.length / 10));
        ExecutorCompletionService<RedPacketSendResult> completion = new ExecutorCompletionService<RedPacketSendResult>(sendExecutor);
        ArrayList<Future<RedPacketSendResult>> callSendList = new ArrayList<Future<RedPacketSendResult>>(redPackets.length);
        for (final RedPacket redpacket : redPackets) {
            Future<RedPacketSendResult> futureSend = completion.submit(new Callable<RedPacketSendResult>(){

                @Override
                public RedPacketSendResult call() throws Exception {
                    return CashProxy.this.sendRedpack(redpacket);
                }
            });
            callSendList.add(futureSend);
        }
        sendExecutor.shutdown();
        return callSendList;
    }

    public RedPacketRecord queryRedpack(String outTradeNo) throws WeixinException {
        Map<String, String> para = this.createBaseRequestMap(null);
        para.put("bill_type", "MCHT");
        para.put("mch_billno", outTradeNo);
        para.put("sign", this.weixinSignature.sign(para));
        String param = XmlFormatter.map2xml(para);
        WeixinResponse response = this.getWeixinSSLExecutor().post("https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo", param);
        return response.getAsObject(new TypeReference<RedPacketRecord>(){});
    }

    public CompanyPaymentResult sendCorpPayment(CompanyPayment payment) throws WeixinException {
        super.declareMerchant(payment);
        JSONObject obj = (JSONObject)JSON.toJSON((Object)payment);
        obj.put("mchid", obj.remove((Object)"mch_id"));
        obj.put("mch_appid", obj.remove((Object)"appid"));
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlFormatter.map2xml(obj);
        WeixinResponse response = this.getWeixinSSLExecutor().post("https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers", param);
        String text = response.getAsString().replaceFirst("<mch_appid>", "<appid>").replaceFirst("</mch_appid>", "</appid>").replaceFirst("<mchid>", "<mch_id>").replaceFirst("</mchid>", "</mch_id>");
        return XmlFormatter.fromXML(text, CompanyPaymentResult.class);
    }

    public CompanyPaymentRecord queryCorpPayment(String outTradeNo) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("nonce_str", (Object)RandomUtil.generateString(16));
        obj.put("mch_id", (Object)this.weixinPayAccount.getMchId());
        obj.put("appid", (Object)this.weixinPayAccount.getId());
        obj.put("partner_trade_no", (Object)outTradeNo);
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlFormatter.map2xml(obj);
        WeixinResponse response = this.getWeixinSSLExecutor().post("https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo", param);
        return response.getAsObject(new TypeReference<CompanyPaymentRecord>(){});
    }

    public SettlementRecord querySettlement(boolean status, Pageable pageable, Date start, Date end) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("nonce_str", (Object)RandomUtil.generateString(16));
        obj.put("mch_id", (Object)this.weixinPayAccount.getMchId());
        obj.put("appid", (Object)this.weixinPayAccount.getId());
        obj.put("usetag", (Object)(status ? 1 : 2));
        obj.put("offset", (Object)pageable.getOffset());
        obj.put("limit", (Object)pageable.getPageSize());
        if (start != null) {
            obj.put("date_start", (Object)DateUtils.fortmat2yyyyMMdd(start));
        }
        if (end != null) {
            obj.put("date_end", (Object)DateUtils.fortmat2yyyyMMdd(end));
        }
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlFormatter.map2xml(obj);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/pay/settlementquery", param);
        return response.getAsObject(new TypeReference<SettlementRecord>(){});
    }

    public double queryExchageRate(CurrencyType currencyType, Date date) throws WeixinException {
        if (date == null) {
            date = new Date();
        }
        JSONObject obj = new JSONObject();
        obj.put("mch_id", (Object)this.weixinPayAccount.getMchId());
        obj.put("appid", (Object)this.weixinPayAccount.getId());
        obj.put("sub_mch_id", (Object)this.weixinPayAccount.getSubMchId());
        obj.put("fee_type", (Object)currencyType.name());
        obj.put("date", (Object)DateUtils.fortmat2yyyyMMdd(date));
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlFormatter.map2xml(obj);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/pay/queryexchagerate", param);
        BigDecimal rate = new BigDecimal(XmlFormatter.xml2map(response.getAsString()).get("rate"));
        return rate.divide(new BigDecimal(1.0E8)).doubleValue();
    }
}

