/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.model.media;

import cn.ipokerface.weixin.model.media.Article;
import cn.ipokerface.weixin.model.media.NotifyMessageTuple;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsMessageTuple
implements NotifyMessageTuple {
    private static final long serialVersionUID = 3348756809039388415L;
    private static final int MAX_ARTICLE_COUNT = 8;
    @JSONField(name="articles")
    @XmlElement(name="Articles")
    private LinkedList<Article> articles = new LinkedList();

    @Override
    public String getMessageType() {
        return "news";
    }

    public NewsMessageTuple addArticle(String title, String desc, String picUrl, String url) {
        return this.addArticle(new Article(title, desc, picUrl, url));
    }

    public NewsMessageTuple addArticle(Article ... articles) {
        for (Article article : articles) {
            this.articles.add(article);
        }
        return this;
    }

    public NewsMessageTuple addFirstArticle(Article article) {
        this.articles.addFirst(article);
        return this;
    }

    public void addLastArticle(Article article) {
        this.articles.addLast(article);
    }

    public NewsMessageTuple removeFirstArticle() {
        this.articles.removeFirst();
        return this;
    }

    public NewsMessageTuple removeLastArticle() {
        this.articles.removeLast();
        return this;
    }

    @JSONField(serialize=false)
    @XmlTransient
    public boolean isMaxCount() {
        return this.articles.size() == 8;
    }

    public List<Article> getArticles() {
        if (this.articles.size() > 8) {
            return this.articles.subList(0, 8);
        }
        return this.articles;
    }

    @JSONField(serialize=false)
    @XmlTransient
    public List<Article> getFullArticles() {
        return this.articles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Article article : this.articles) {
            sb.append("{title=").append(article.getTitle());
            sb.append(" ,description=").append(article.getDesc());
            sb.append(" ,picUrl=").append(article.getPicUrl());
            sb.append(" ,url=").append(article.getUrl()).append("}");
        }
        return sb.toString();
    }
}

